using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmJustifyAboRHChange
	/// </summary>
	public class FrmJustifyAboRHChange : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables
		
		private BOL.Patient _patient;
		private ArrayList _patientABORhHistory;

		private DataTable _dtComments;
		private ArrayList _abo;
		private ArrayList _rh;

		private bool _detailsRequired = false;
		private Guid _cannedCommentGuid;

		#endregion

		#region Form Controls

		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancelChange;
		private System.Windows.Forms.GroupBox grpJustify;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpCurrentABORh;
		private System.Windows.Forms.TextBox txtCurrentDivision;
		private System.Windows.Forms.Label lblCurrentDivision;
		private System.Windows.Forms.TextBox txtCurrentDate;
		private System.Windows.Forms.Label lblCurrentDate;
		private System.Windows.Forms.TextBox txtCurrentRhComment;
		private System.Windows.Forms.Label lblCurrentRhComment;
		private System.Windows.Forms.TextBox txtCurrentRh;
		private System.Windows.Forms.Label lblCurrentRh;
		private System.Windows.Forms.TextBox txtCurrentABOComment;
		private System.Windows.Forms.Label lblCurrentABOComment;
		private System.Windows.Forms.TextBox txtCurrentABO;
		private System.Windows.Forms.Label lblCurrentABO;
		private System.Windows.Forms.GroupBox grpHistoricalABORh;
		private System.Windows.Forms.TextBox txtHistoricalDivision;
		private System.Windows.Forms.Label lblHistoricalDivision;
		private System.Windows.Forms.TextBox txtHistoricalTested;
		private System.Windows.Forms.Label lblHistoricalTested;
		private System.Windows.Forms.TextBox txtHistoricalRh;
		private System.Windows.Forms.Label lblHistoricalRh;
		private System.Windows.Forms.TextBox txtHistoricalABO;
		private System.Windows.Forms.Label lblHistoricalABO;
		private System.Windows.Forms.TextBox txtHistoricalRhComment;
		private System.Windows.Forms.Label lblHistoricalRhComment;
		private System.Windows.Forms.TextBox txtHistoricalABOComment;
		private System.Windows.Forms.Label lblHistoricalABOComment;
		private System.Windows.Forms.Panel pnlJustifyABORh;
		private System.Windows.Forms.Panel pnlJustify;
		private System.Windows.Forms.Panel pnlTop;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.Panel pnlSelectPatient;
        private gov.va.med.vbecs.GUI.controls.PatientSelectTool patientSelectTool1;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpComments;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbABO;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbRh;
		private System.Windows.Forms.Label lblJustifiedABO;
		private System.Windows.Forms.Label lblJustifiedRh;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox txtDetails;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private System.Windows.Forms.Label lblDetails;
		private System.Windows.Forms.Label lblComment;
        private gov.va.med.vbecs.GUI.controls.VbecsButton btnSave;
        private controls.PatientDisplayPanel patientDisplayPanel1;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructor/Dispose

		/// <summary>
		/// FrmJustifyAboRHChange()
		/// </summary>
		public FrmJustifyAboRHChange()
		{
			InitializeComponent();
			SetComponentProperties();
			LoadCannedComments();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmJustifyAboRHChange));
            this.pnlSelectPatient = new System.Windows.Forms.Panel();
            this.patientSelectTool1 = new gov.va.med.vbecs.GUI.controls.PatientSelectTool();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.pnlJustifyABORh = new System.Windows.Forms.Panel();
            this.patientDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
            this.pnlJustify = new System.Windows.Forms.Panel();
            this.grpJustify = new System.Windows.Forms.GroupBox();
            this.cmbRh = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.grpComments = new System.Windows.Forms.GroupBox();
            this.txtDetails = new System.Windows.Forms.TextBox();
            this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblDetails = new System.Windows.Forms.Label();
            this.lblComment = new System.Windows.Forms.Label();
            this.cmbABO = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblJustifiedRh = new System.Windows.Forms.Label();
            this.lblJustifiedABO = new System.Windows.Forms.Label();
            this.label1 = new System.Windows.Forms.Label();
            this.pnlTop = new System.Windows.Forms.Panel();
            this.grpCurrentABORh = new System.Windows.Forms.GroupBox();
            this.txtCurrentDivision = new System.Windows.Forms.TextBox();
            this.lblCurrentDivision = new System.Windows.Forms.Label();
            this.txtCurrentDate = new System.Windows.Forms.TextBox();
            this.lblCurrentDate = new System.Windows.Forms.Label();
            this.txtCurrentRhComment = new System.Windows.Forms.TextBox();
            this.lblCurrentRhComment = new System.Windows.Forms.Label();
            this.txtCurrentRh = new System.Windows.Forms.TextBox();
            this.lblCurrentRh = new System.Windows.Forms.Label();
            this.txtCurrentABOComment = new System.Windows.Forms.TextBox();
            this.lblCurrentABOComment = new System.Windows.Forms.Label();
            this.txtCurrentABO = new System.Windows.Forms.TextBox();
            this.lblCurrentABO = new System.Windows.Forms.Label();
            this.splitter1 = new System.Windows.Forms.Splitter();
            this.grpHistoricalABORh = new System.Windows.Forms.GroupBox();
            this.txtHistoricalRhComment = new System.Windows.Forms.TextBox();
            this.lblHistoricalRhComment = new System.Windows.Forms.Label();
            this.txtHistoricalABOComment = new System.Windows.Forms.TextBox();
            this.lblHistoricalABOComment = new System.Windows.Forms.Label();
            this.txtHistoricalDivision = new System.Windows.Forms.TextBox();
            this.lblHistoricalDivision = new System.Windows.Forms.Label();
            this.txtHistoricalTested = new System.Windows.Forms.TextBox();
            this.lblHistoricalTested = new System.Windows.Forms.Label();
            this.txtHistoricalRh = new System.Windows.Forms.TextBox();
            this.lblHistoricalRh = new System.Windows.Forms.Label();
            this.txtHistoricalABO = new System.Windows.Forms.TextBox();
            this.lblHistoricalABO = new System.Windows.Forms.Label();
            this.btnSave = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnCancelChange = new System.Windows.Forms.Button();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.pnlSelectPatient.SuspendLayout();
            this.pnlJustifyABORh.SuspendLayout();
            this.pnlJustify.SuspendLayout();
            this.grpJustify.SuspendLayout();
            this.grpComments.SuspendLayout();
            this.pnlTop.SuspendLayout();
            this.grpCurrentABORh.SuspendLayout();
            this.grpHistoricalABORh.SuspendLayout();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.TabIndex = 2;
            this.vbecsLogo1.Title = "Justify ABO/Rh Change";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 415);
            this.lblRequiredField.TabIndex = 3;
            // 
            // pnlSelectPatient
            // 
            this.pnlSelectPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlSelectPatient.Controls.Add(this.patientSelectTool1);
            this.pnlSelectPatient.Controls.Add(this.btnCancel);
            this.pnlSelectPatient.Controls.Add(this.btnOK);
            this.pnlSelectPatient.Location = new System.Drawing.Point(0, 32);
            this.pnlSelectPatient.Name = "pnlSelectPatient";
            this.pnlSelectPatient.Size = new System.Drawing.Size(642, 396);
            this.pnlSelectPatient.TabIndex = 0;
            // 
            // patientSelectTool1
            // 
            this.patientSelectTool1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientSelectTool1.DisplaySIAndTRs = true;
            this.patientSelectTool1.EnabledBloodAvailButton = false;
            this.patientSelectTool1.EnabledMedicationButton = false;
            this.patientSelectTool1.EnabledRecentOrdersButton = false;
            this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientSelectTool1.EnabledSIAndTRButton = false;
            this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
            this.patientSelectTool1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.hlphelpChm.SetHelpKeyword(this.patientSelectTool1, "Justify_ABO_Rh_Change.htm");
            this.hlphelpChm.SetHelpNavigator(this.patientSelectTool1, System.Windows.Forms.HelpNavigator.Topic);
            this.patientSelectTool1.Location = new System.Drawing.Point(0, 0);
            this.patientSelectTool1.Name = "patientSelectTool1";
            this.patientSelectTool1.SearchVistaLink = false;
            this.hlphelpChm.SetShowHelp(this.patientSelectTool1, true);
            this.patientSelectTool1.Size = new System.Drawing.Size(642, 364);
            this.patientSelectTool1.TabIndex = 0;
            this.patientSelectTool1.PatientSelected += new System.EventHandler(this.patientSelectTool1_PatientSelected);
            this.patientSelectTool1.PatientDeselected += new System.EventHandler(this.patientSelectTool1_PatientDeselected);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.CausesValidation = false;
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(566, 368);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = null;
            this.btnOK.Location = new System.Drawing.Point(486, 368);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 1;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // pnlJustifyABORh
            // 
            this.pnlJustifyABORh.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlJustifyABORh.Controls.Add(this.patientDisplayPanel1);
            this.pnlJustifyABORh.Controls.Add(this.pnlJustify);
            this.pnlJustifyABORh.Controls.Add(this.btnSave);
            this.pnlJustifyABORh.Controls.Add(this.btnCancelChange);
            this.pnlJustifyABORh.Controls.Add(this.grpImage);
            this.pnlJustifyABORh.Location = new System.Drawing.Point(0, 32);
            this.pnlJustifyABORh.Name = "pnlJustifyABORh";
            this.pnlJustifyABORh.Size = new System.Drawing.Size(642, 396);
            this.pnlJustifyABORh.TabIndex = 1;
            this.pnlJustifyABORh.Visible = false;
            // 
            // patientDisplayPanel1
            // 
            this.patientDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientDisplayPanel1.EnabledBloodAvailButton = false;
            this.patientDisplayPanel1.EnabledMedicationButton = false;
            this.patientDisplayPanel1.EnabledRecentOrdersButton = false;
            this.patientDisplayPanel1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientDisplayPanel1.EnabledSIAndTRButton = false;
            this.patientDisplayPanel1.EnabledTransfusionReactionHistoryButton = false;
            this.patientDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientDisplayPanel1.Location = new System.Drawing.Point(4, 0);
            this.patientDisplayPanel1.Name = "patientDisplayPanel1";
            this.patientDisplayPanel1.Patient = null;
            this.patientDisplayPanel1.Size = new System.Drawing.Size(638, 40);
            this.patientDisplayPanel1.TabIndex = 23;
            // 
            // pnlJustify
            // 
            this.pnlJustify.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlJustify.Controls.Add(this.grpJustify);
            this.pnlJustify.Controls.Add(this.pnlTop);
            this.pnlJustify.Location = new System.Drawing.Point(48, 44);
            this.pnlJustify.Name = "pnlJustify";
            this.pnlJustify.Size = new System.Drawing.Size(590, 322);
            this.pnlJustify.TabIndex = 2;
            // 
            // grpJustify
            // 
            this.grpJustify.AccessibleDescription = "Justified A B O R H Change";
            this.grpJustify.AccessibleName = "Justified A B O R H Change";
            this.grpJustify.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpJustify.Controls.Add(this.cmbRh);
            this.grpJustify.Controls.Add(this.grpComments);
            this.grpJustify.Controls.Add(this.cmbABO);
            this.grpJustify.Controls.Add(this.lblJustifiedRh);
            this.grpJustify.Controls.Add(this.lblJustifiedABO);
            this.grpJustify.Controls.Add(this.label1);
            this.grpJustify.Location = new System.Drawing.Point(0, 212);
            this.grpJustify.Name = "grpJustify";
            this.grpJustify.Size = new System.Drawing.Size(590, 108);
            this.grpJustify.TabIndex = 15;
            this.grpJustify.TabStop = false;
            this.grpJustify.Text = "Justified ABO/Rh Change";
            // 
            // cmbRh
            // 
            this.cmbRh.AccessibleDescription = "Justified R H";
            this.cmbRh.AccessibleName = "Justified R H";
            this.cmbRh.Interval = 500;
            this.cmbRh.Location = new System.Drawing.Point(92, 76);
            this.cmbRh.MaxLength = 12;
            this.cmbRh.Name = "cmbRh";
            this.cmbRh.Size = new System.Drawing.Size(96, 22);
            this.cmbRh.TabIndex = 17;
            this.cmbRh.SelectedIndexChanged += new System.EventHandler(this.cmbRh_SelectedIndexChanged);
            // 
            // grpComments
            // 
            this.grpComments.AccessibleDescription = "Comments";
            this.grpComments.AccessibleName = "Comments";
            this.grpComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpComments.Controls.Add(this.txtDetails);
            this.grpComments.Controls.Add(this.cmbComment);
            this.grpComments.Controls.Add(this.lblDetails);
            this.grpComments.Controls.Add(this.lblComment);
            this.grpComments.Location = new System.Drawing.Point(299, 12);
            this.grpComments.Name = "grpComments";
            this.grpComments.Size = new System.Drawing.Size(285, 88);
            this.grpComments.TabIndex = 18;
            this.grpComments.TabStop = false;
            this.grpComments.Text = "Comments";
            // 
            // txtDetails
            // 
            this.txtDetails.AccessibleDescription = "Detaiils";
            this.txtDetails.AccessibleName = "Detaiils";
            this.txtDetails.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtDetails.Location = new System.Drawing.Point(64, 40);
            this.txtDetails.MaxLength = 255;
            this.txtDetails.Multiline = true;
            this.txtDetails.Name = "txtDetails";
            this.txtDetails.Size = new System.Drawing.Size(201, 40);
            this.txtDetails.TabIndex = 20;
            this.txtDetails.TextChanged += new System.EventHandler(this.txtDetails_TextChanged);
            // 
            // cmbComment
            // 
            this.cmbComment.AccessibleDescription = "Comments";
            this.cmbComment.AccessibleName = "Comments";
            this.cmbComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbComment.Interval = 500;
            this.cmbComment.Location = new System.Drawing.Point(64, 16);
            this.cmbComment.MaxLength = 80;
            this.cmbComment.Name = "cmbComment";
            this.cmbComment.Size = new System.Drawing.Size(201, 22);
            this.cmbComment.TabIndex = 19;
            this.cmbComment.SelectedIndexChanged += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
            // 
            // lblDetails
            // 
            this.lblDetails.Location = new System.Drawing.Point(8, 40);
            this.lblDetails.Name = "lblDetails";
            this.lblDetails.Size = new System.Drawing.Size(60, 20);
            this.lblDetails.TabIndex = 2;
            this.lblDetails.Text = "Details";
            this.lblDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblComment
            // 
            this.lblComment.Location = new System.Drawing.Point(8, 16);
            this.lblComment.Name = "lblComment";
            this.lblComment.Size = new System.Drawing.Size(60, 20);
            this.lblComment.TabIndex = 0;
            this.lblComment.Text = "Comment*";
            this.lblComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // cmbABO
            // 
            this.cmbABO.AccessibleDescription = "Justified A B O ";
            this.cmbABO.AccessibleName = "Justified A B O ";
            this.cmbABO.Interval = 500;
            this.cmbABO.Location = new System.Drawing.Point(92, 52);
            this.cmbABO.MaxLength = 12;
            this.cmbABO.Name = "cmbABO";
            this.cmbABO.Size = new System.Drawing.Size(96, 22);
            this.cmbABO.TabIndex = 16;
            this.cmbABO.SelectedIndexChanged += new System.EventHandler(this.cmbABO_SelectedIndexChanged);
            // 
            // lblJustifiedRh
            // 
            this.lblJustifiedRh.Location = new System.Drawing.Point(8, 76);
            this.lblJustifiedRh.Name = "lblJustifiedRh";
            this.lblJustifiedRh.Size = new System.Drawing.Size(80, 20);
            this.lblJustifiedRh.TabIndex = 3;
            this.lblJustifiedRh.Text = "Justified Rh*";
            this.lblJustifiedRh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblJustifiedABO
            // 
            this.lblJustifiedABO.Location = new System.Drawing.Point(8, 52);
            this.lblJustifiedABO.Name = "lblJustifiedABO";
            this.lblJustifiedABO.Size = new System.Drawing.Size(80, 20);
            this.lblJustifiedABO.TabIndex = 1;
            this.lblJustifiedABO.Text = "Justified ABO*";
            this.lblJustifiedABO.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // label1
            // 
            this.label1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.label1.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label1.Location = new System.Drawing.Point(8, 16);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(284, 32);
            this.label1.TabIndex = 0;
            this.label1.Text = "WARNING: Use this option only when both the current and previous specimen tests a" +
    "re valid.";
            this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // pnlTop
            // 
            this.pnlTop.Controls.Add(this.grpCurrentABORh);
            this.pnlTop.Controls.Add(this.splitter1);
            this.pnlTop.Controls.Add(this.grpHistoricalABORh);
            this.pnlTop.Dock = System.Windows.Forms.DockStyle.Top;
            this.pnlTop.Location = new System.Drawing.Point(0, 0);
            this.pnlTop.Name = "pnlTop";
            this.pnlTop.Size = new System.Drawing.Size(590, 208);
            this.pnlTop.TabIndex = 0;
            // 
            // grpCurrentABORh
            // 
            this.grpCurrentABORh.AccessibleDescription = "Current Specimen A B O R H";
            this.grpCurrentABORh.AccessibleName = "Current Specimen A B O R H";
            this.grpCurrentABORh.Controls.Add(this.txtCurrentDivision);
            this.grpCurrentABORh.Controls.Add(this.lblCurrentDivision);
            this.grpCurrentABORh.Controls.Add(this.txtCurrentDate);
            this.grpCurrentABORh.Controls.Add(this.lblCurrentDate);
            this.grpCurrentABORh.Controls.Add(this.txtCurrentRhComment);
            this.grpCurrentABORh.Controls.Add(this.lblCurrentRhComment);
            this.grpCurrentABORh.Controls.Add(this.txtCurrentRh);
            this.grpCurrentABORh.Controls.Add(this.lblCurrentRh);
            this.grpCurrentABORh.Controls.Add(this.txtCurrentABOComment);
            this.grpCurrentABORh.Controls.Add(this.lblCurrentABOComment);
            this.grpCurrentABORh.Controls.Add(this.txtCurrentABO);
            this.grpCurrentABORh.Controls.Add(this.lblCurrentABO);
            this.grpCurrentABORh.Dock = System.Windows.Forms.DockStyle.Fill;
            this.grpCurrentABORh.Location = new System.Drawing.Point(299, 0);
            this.grpCurrentABORh.Name = "grpCurrentABORh";
            this.grpCurrentABORh.Size = new System.Drawing.Size(291, 208);
            this.grpCurrentABORh.TabIndex = 8;
            this.grpCurrentABORh.TabStop = false;
            this.grpCurrentABORh.Text = "Current Specimen ABO/Rh";
            // 
            // txtCurrentDivision
            // 
            this.txtCurrentDivision.AccessibleDescription = "Division Tested";
            this.txtCurrentDivision.AccessibleName = "Division Tested";
            this.txtCurrentDivision.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtCurrentDivision.Location = new System.Drawing.Point(92, 48);
            this.txtCurrentDivision.Name = "txtCurrentDivision";
            this.txtCurrentDivision.ReadOnly = true;
            this.txtCurrentDivision.Size = new System.Drawing.Size(191, 20);
            this.txtCurrentDivision.TabIndex = 10;
            // 
            // lblCurrentDivision
            // 
            this.lblCurrentDivision.Location = new System.Drawing.Point(8, 48);
            this.lblCurrentDivision.Name = "lblCurrentDivision";
            this.lblCurrentDivision.Size = new System.Drawing.Size(84, 20);
            this.lblCurrentDivision.TabIndex = 2;
            this.lblCurrentDivision.Text = "Division Tested";
            this.lblCurrentDivision.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtCurrentDate
            // 
            this.txtCurrentDate.AccessibleDescription = "Date Tested";
            this.txtCurrentDate.AccessibleName = "Date Tested";
            this.txtCurrentDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtCurrentDate.Location = new System.Drawing.Point(92, 24);
            this.txtCurrentDate.Name = "txtCurrentDate";
            this.txtCurrentDate.ReadOnly = true;
            this.txtCurrentDate.Size = new System.Drawing.Size(191, 20);
            this.txtCurrentDate.TabIndex = 9;
            // 
            // lblCurrentDate
            // 
            this.lblCurrentDate.Location = new System.Drawing.Point(8, 24);
            this.lblCurrentDate.Name = "lblCurrentDate";
            this.lblCurrentDate.Size = new System.Drawing.Size(84, 20);
            this.lblCurrentDate.TabIndex = 0;
            this.lblCurrentDate.Text = "Date Tested";
            this.lblCurrentDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtCurrentRhComment
            // 
            this.txtCurrentRhComment.AccessibleDescription = "R H Comment";
            this.txtCurrentRhComment.AccessibleName = "R H Comment";
            this.txtCurrentRhComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtCurrentRhComment.Location = new System.Drawing.Point(92, 160);
            this.txtCurrentRhComment.Multiline = true;
            this.txtCurrentRhComment.Name = "txtCurrentRhComment";
            this.txtCurrentRhComment.ReadOnly = true;
            this.txtCurrentRhComment.Size = new System.Drawing.Size(191, 36);
            this.txtCurrentRhComment.TabIndex = 14;
            // 
            // lblCurrentRhComment
            // 
            this.lblCurrentRhComment.Location = new System.Drawing.Point(8, 160);
            this.lblCurrentRhComment.Name = "lblCurrentRhComment";
            this.lblCurrentRhComment.Size = new System.Drawing.Size(92, 20);
            this.lblCurrentRhComment.TabIndex = 10;
            this.lblCurrentRhComment.Text = "Rh Comment";
            this.lblCurrentRhComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtCurrentRh
            // 
            this.txtCurrentRh.AccessibleDescription = "R H ";
            this.txtCurrentRh.AccessibleName = "R H ";
            this.txtCurrentRh.Location = new System.Drawing.Point(92, 96);
            this.txtCurrentRh.Name = "txtCurrentRh";
            this.txtCurrentRh.ReadOnly = true;
            this.txtCurrentRh.Size = new System.Drawing.Size(76, 20);
            this.txtCurrentRh.TabIndex = 12;
            // 
            // lblCurrentRh
            // 
            this.lblCurrentRh.Location = new System.Drawing.Point(8, 96);
            this.lblCurrentRh.Name = "lblCurrentRh";
            this.lblCurrentRh.Size = new System.Drawing.Size(44, 20);
            this.lblCurrentRh.TabIndex = 6;
            this.lblCurrentRh.Text = "Rh";
            this.lblCurrentRh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtCurrentABOComment
            // 
            this.txtCurrentABOComment.AccessibleDescription = "A B O Comment";
            this.txtCurrentABOComment.AccessibleName = "A B O Comment";
            this.txtCurrentABOComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtCurrentABOComment.Location = new System.Drawing.Point(92, 120);
            this.txtCurrentABOComment.Multiline = true;
            this.txtCurrentABOComment.Name = "txtCurrentABOComment";
            this.txtCurrentABOComment.ReadOnly = true;
            this.txtCurrentABOComment.Size = new System.Drawing.Size(191, 36);
            this.txtCurrentABOComment.TabIndex = 13;
            // 
            // lblCurrentABOComment
            // 
            this.lblCurrentABOComment.Location = new System.Drawing.Point(8, 120);
            this.lblCurrentABOComment.Name = "lblCurrentABOComment";
            this.lblCurrentABOComment.Size = new System.Drawing.Size(88, 20);
            this.lblCurrentABOComment.TabIndex = 8;
            this.lblCurrentABOComment.Text = "ABO Comment";
            this.lblCurrentABOComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtCurrentABO
            // 
            this.txtCurrentABO.AccessibleDescription = "A B O";
            this.txtCurrentABO.AccessibleName = "A B O";
            this.txtCurrentABO.Location = new System.Drawing.Point(92, 72);
            this.txtCurrentABO.Name = "txtCurrentABO";
            this.txtCurrentABO.ReadOnly = true;
            this.txtCurrentABO.Size = new System.Drawing.Size(76, 20);
            this.txtCurrentABO.TabIndex = 11;
            // 
            // lblCurrentABO
            // 
            this.lblCurrentABO.Location = new System.Drawing.Point(8, 72);
            this.lblCurrentABO.Name = "lblCurrentABO";
            this.lblCurrentABO.Size = new System.Drawing.Size(44, 20);
            this.lblCurrentABO.TabIndex = 4;
            this.lblCurrentABO.Text = "ABO";
            this.lblCurrentABO.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // splitter1
            // 
            this.splitter1.Location = new System.Drawing.Point(291, 0);
            this.splitter1.MinSize = 160;
            this.splitter1.Name = "splitter1";
            this.splitter1.Size = new System.Drawing.Size(8, 208);
            this.splitter1.TabIndex = 1;
            this.splitter1.TabStop = false;
            // 
            // grpHistoricalABORh
            // 
            this.grpHistoricalABORh.AccessibleDescription = "Historical A B O R h";
            this.grpHistoricalABORh.AccessibleName = "Historical A B O R h";
            this.grpHistoricalABORh.Controls.Add(this.txtHistoricalRhComment);
            this.grpHistoricalABORh.Controls.Add(this.lblHistoricalRhComment);
            this.grpHistoricalABORh.Controls.Add(this.txtHistoricalABOComment);
            this.grpHistoricalABORh.Controls.Add(this.lblHistoricalABOComment);
            this.grpHistoricalABORh.Controls.Add(this.txtHistoricalDivision);
            this.grpHistoricalABORh.Controls.Add(this.lblHistoricalDivision);
            this.grpHistoricalABORh.Controls.Add(this.txtHistoricalTested);
            this.grpHistoricalABORh.Controls.Add(this.lblHistoricalTested);
            this.grpHistoricalABORh.Controls.Add(this.txtHistoricalRh);
            this.grpHistoricalABORh.Controls.Add(this.lblHistoricalRh);
            this.grpHistoricalABORh.Controls.Add(this.txtHistoricalABO);
            this.grpHistoricalABORh.Controls.Add(this.lblHistoricalABO);
            this.grpHistoricalABORh.Dock = System.Windows.Forms.DockStyle.Left;
            this.grpHistoricalABORh.Location = new System.Drawing.Point(0, 0);
            this.grpHistoricalABORh.Name = "grpHistoricalABORh";
            this.grpHistoricalABORh.Size = new System.Drawing.Size(291, 208);
            this.grpHistoricalABORh.TabIndex = 1;
            this.grpHistoricalABORh.TabStop = false;
            this.grpHistoricalABORh.Text = "Historical ABO/Rh";
            // 
            // txtHistoricalRhComment
            // 
            this.txtHistoricalRhComment.AccessibleDescription = "R H Comment";
            this.txtHistoricalRhComment.AccessibleName = "R H Comment";
            this.txtHistoricalRhComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtHistoricalRhComment.Location = new System.Drawing.Point(92, 160);
            this.txtHistoricalRhComment.Multiline = true;
            this.txtHistoricalRhComment.Name = "txtHistoricalRhComment";
            this.txtHistoricalRhComment.ReadOnly = true;
            this.txtHistoricalRhComment.Size = new System.Drawing.Size(191, 36);
            this.txtHistoricalRhComment.TabIndex = 7;
            // 
            // lblHistoricalRhComment
            // 
            this.lblHistoricalRhComment.Location = new System.Drawing.Point(8, 160);
            this.lblHistoricalRhComment.Name = "lblHistoricalRhComment";
            this.lblHistoricalRhComment.Size = new System.Drawing.Size(92, 20);
            this.lblHistoricalRhComment.TabIndex = 10;
            this.lblHistoricalRhComment.Text = "Rh Comment";
            this.lblHistoricalRhComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtHistoricalABOComment
            // 
            this.txtHistoricalABOComment.AccessibleDescription = "A B O Comment";
            this.txtHistoricalABOComment.AccessibleName = "A B O Comment";
            this.txtHistoricalABOComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtHistoricalABOComment.Location = new System.Drawing.Point(92, 120);
            this.txtHistoricalABOComment.Multiline = true;
            this.txtHistoricalABOComment.Name = "txtHistoricalABOComment";
            this.txtHistoricalABOComment.ReadOnly = true;
            this.txtHistoricalABOComment.Size = new System.Drawing.Size(191, 36);
            this.txtHistoricalABOComment.TabIndex = 6;
            // 
            // lblHistoricalABOComment
            // 
            this.lblHistoricalABOComment.Location = new System.Drawing.Point(8, 120);
            this.lblHistoricalABOComment.Name = "lblHistoricalABOComment";
            this.lblHistoricalABOComment.Size = new System.Drawing.Size(88, 20);
            this.lblHistoricalABOComment.TabIndex = 8;
            this.lblHistoricalABOComment.Text = "ABO Comment";
            this.lblHistoricalABOComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtHistoricalDivision
            // 
            this.txtHistoricalDivision.AccessibleDescription = "Division Tested";
            this.txtHistoricalDivision.AccessibleName = "Division Tested";
            this.txtHistoricalDivision.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtHistoricalDivision.Location = new System.Drawing.Point(92, 48);
            this.txtHistoricalDivision.Name = "txtHistoricalDivision";
            this.txtHistoricalDivision.ReadOnly = true;
            this.txtHistoricalDivision.Size = new System.Drawing.Size(191, 20);
            this.txtHistoricalDivision.TabIndex = 3;
            // 
            // lblHistoricalDivision
            // 
            this.lblHistoricalDivision.Location = new System.Drawing.Point(8, 48);
            this.lblHistoricalDivision.Name = "lblHistoricalDivision";
            this.lblHistoricalDivision.Size = new System.Drawing.Size(84, 20);
            this.lblHistoricalDivision.TabIndex = 2;
            this.lblHistoricalDivision.Text = "Division Tested";
            this.lblHistoricalDivision.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtHistoricalTested
            // 
            this.txtHistoricalTested.AccessibleDescription = "Date Tested";
            this.txtHistoricalTested.AccessibleName = "Date Tested";
            this.txtHistoricalTested.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtHistoricalTested.Location = new System.Drawing.Point(92, 24);
            this.txtHistoricalTested.Name = "txtHistoricalTested";
            this.txtHistoricalTested.ReadOnly = true;
            this.txtHistoricalTested.Size = new System.Drawing.Size(191, 20);
            this.txtHistoricalTested.TabIndex = 2;
            // 
            // lblHistoricalTested
            // 
            this.lblHistoricalTested.Location = new System.Drawing.Point(8, 24);
            this.lblHistoricalTested.Name = "lblHistoricalTested";
            this.lblHistoricalTested.Size = new System.Drawing.Size(84, 20);
            this.lblHistoricalTested.TabIndex = 0;
            this.lblHistoricalTested.Text = "Date Tested";
            this.lblHistoricalTested.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtHistoricalRh
            // 
            this.txtHistoricalRh.AccessibleDescription = "R H";
            this.txtHistoricalRh.AccessibleName = "R H";
            this.txtHistoricalRh.Location = new System.Drawing.Point(92, 96);
            this.txtHistoricalRh.Name = "txtHistoricalRh";
            this.txtHistoricalRh.ReadOnly = true;
            this.txtHistoricalRh.Size = new System.Drawing.Size(76, 20);
            this.txtHistoricalRh.TabIndex = 5;
            // 
            // lblHistoricalRh
            // 
            this.lblHistoricalRh.Location = new System.Drawing.Point(8, 96);
            this.lblHistoricalRh.Name = "lblHistoricalRh";
            this.lblHistoricalRh.Size = new System.Drawing.Size(44, 20);
            this.lblHistoricalRh.TabIndex = 6;
            this.lblHistoricalRh.Text = "Rh";
            this.lblHistoricalRh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtHistoricalABO
            // 
            this.txtHistoricalABO.AccessibleDescription = "A B O";
            this.txtHistoricalABO.AccessibleName = "A B O";
            this.txtHistoricalABO.Location = new System.Drawing.Point(92, 72);
            this.txtHistoricalABO.Name = "txtHistoricalABO";
            this.txtHistoricalABO.ReadOnly = true;
            this.txtHistoricalABO.Size = new System.Drawing.Size(76, 20);
            this.txtHistoricalABO.TabIndex = 4;
            // 
            // lblHistoricalABO
            // 
            this.lblHistoricalABO.Location = new System.Drawing.Point(8, 72);
            this.lblHistoricalABO.Name = "lblHistoricalABO";
            this.lblHistoricalABO.Size = new System.Drawing.Size(44, 20);
            this.lblHistoricalABO.TabIndex = 4;
            this.lblHistoricalABO.Text = "ABO";
            this.lblHistoricalABO.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // btnSave
            // 
            this.btnSave.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSave.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnSave.Image = ((System.Drawing.Image)(resources.GetObject("btnSave.Image")));
            this.btnSave.Location = new System.Drawing.Point(482, 368);
            this.btnSave.Name = "btnSave";
            this.btnSave.Size = new System.Drawing.Size(75, 23);
            this.btnSave.TabIndex = 21;
            this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
            // 
            // btnCancelChange
            // 
            this.btnCancelChange.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancelChange.CausesValidation = false;
            this.btnCancelChange.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancelChange.Location = new System.Drawing.Point(562, 368);
            this.btnCancelChange.Name = "btnCancelChange";
            this.btnCancelChange.Size = new System.Drawing.Size(75, 23);
            this.btnCancelChange.TabIndex = 22;
            this.btnCancelChange.Text = "&Cancel";
            this.btnCancelChange.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 44);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(40, 320);
            this.grpImage.TabIndex = 1;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(32, 32);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // FrmJustifyAboRHChange
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(642, 429);
            this.Controls.Add(this.pnlJustifyABORh);
            this.Controls.Add(this.pnlSelectPatient);
            this.hlphelpChm.SetHelpKeyword(this, "Justify_ABO_Rh_Change.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(650, 456);
            this.Name = "FrmJustifyAboRHChange";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Justify ABO/Rh Change";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmJustifyAboRHChange_KeyDownSpeakMessage);
            this.Load += new System.EventHandler(this.FrmJustifyAboRHChange_Load);
            this.Controls.SetChildIndex(this.pnlSelectPatient, 0);
            this.Controls.SetChildIndex(this.pnlJustifyABORh, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.pnlSelectPatient.ResumeLayout(false);
            this.pnlJustifyABORh.ResumeLayout(false);
            this.pnlJustify.ResumeLayout(false);
            this.grpJustify.ResumeLayout(false);
            this.grpComments.ResumeLayout(false);
            this.grpComments.PerformLayout();
            this.pnlTop.ResumeLayout(false);
            this.grpCurrentABORh.ResumeLayout(false);
            this.grpCurrentABORh.PerformLayout();
            this.grpHistoricalABORh.ResumeLayout(false);
            this.grpHistoricalABORh.PerformLayout();
            this.grpImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		#region Properties

		/// <summary>
		/// Returns the comments from the Comment combo box appended to any text in the 
		/// Details test box
		/// Implements BR_2.40 for UC_100
		/// </summary>
		public string Comment
		{
			get
			{
				string comment = "";
				if (this.cmbComment.SelectedIndex>-1)
				{
					if (this.cmbComment.Text.Trim().ToUpper() != "OTHER")
					{
						comment	= this.cmbComment.Text;
					}
					if (this.txtDetails.Text.Trim().Length>0)
					{
						if ((comment.Length>0) && (comment[comment.Length-1] != '.'))
						{
							comment = comment + ". ";
						}
						comment = comment + this.txtDetails.Text;
					}
				}
				return comment;
			}
		}

		/// <summary>
		/// Returns the Canned Comment GUID
		/// </summary>
		public Guid CannedCommentGuid
		{
			get
			{
				return _cannedCommentGuid;
			}
			
		}
		/// <summary>
		/// Returns text from the Details text bo
		/// </summary>
		public string Details
		{
			get
			{
				return this.txtDetails.Text;
			}
		}

		#endregion

		#region Events

		/// <summary>
		/// Patient selected event handler. Enables OK button.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void patientSelectTool1_PatientSelected(object sender, System.EventArgs e)
		{
			this._patient = patientSelectTool1.SelectedPatient;
			//
			this.btnOK.EnabledButton = true;
			this.SetThisToolTip(this.btnOK,Common.StrRes.Tooltips.Common.OKToContinue());
		}

		/// <summary>
		/// Patient deselected event handler. Disables OK button.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void patientSelectTool1_PatientDeselected(object sender, System.EventArgs e)
		{
			this._patient = null;
			//
			this.btnOK.EnabledButton = false;
			this.SetThisToolTip(this.btnOK,Common.StrRes.Tooltips.Common.SelectPatient());
		}

		/// <summary>
		/// Cancel button click event. Closes form.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// OK button click event. Checks if patient selection is valid and switches panels.
		/// BR_100.01
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this._patientABORhHistory = this._patient.GetPatientAboRHHistoryForJustification();
			if (this._patientABORhHistory.Count==0)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC100.NoJustificationRequired());
				return;
			}
			
			//Iterate through all the SpecimenTest objects
			this.LockController.RecordGuids.Add(this._patient.PatientGuid);
			foreach(BOL.SpecimenTest sTest in this._patientABORhHistory)
			{
				this.LockController.RecordGuids.Add(sTest.SpecimenTestGuid);
			}

			if (!this.SetLocks())   return;

			this.patientDisplayPanel1.Patient = this._patient;
			this.pnlJustifyABORh.Visible = true;
			this.patientDisplayPanel1.Focus();
			this.pnlSelectPatient.Visible = false;
			this.LoadPatient();
			this.SetDirtyFlag(sender,e);
		}

		/// <summary>
		/// Save button click event. Updates justified patient ABO/Rh and closes form
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnSave_Click(object sender, System.EventArgs e)
		{
			if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("justified ABO/Rh"))!=DialogResult.Yes)
			{
				return;
			}
			//
			
			bool result = this._patient.JustifyPatientABORhChange(this._abo[this.cmbABO.SelectedIndex].ToString(),this._rh[this.cmbRh.SelectedIndex].ToString(),this.Comment);
			//CR 1441
			System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.Justification);
			if(dt!= null)
			{
				if(dt.Rows.Count == 0)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
				}
			}
			if (result)
			{
				this.IsDirty = false;
				this.Close();
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UpdateFailed("patient justified ABO/Rh"));
			}
		}

		/// <summary>
		/// Form Load
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void FrmJustifyAboRHChange_Load(object sender, System.EventArgs e)
		{
			this.IsDirty = false;
		}

		/// <summary>
		/// Comment combo box selected index changed event handler. Sets canned comment GUID.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cmbComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.CheckIfDetailsRequired();
			//
			this.CheckValid();
			//
			if( this.cmbComment.SelectedIndex > -1 )
			{
				this._cannedCommentGuid = (Guid)_dtComments.Rows[this.cmbComment.SelectedIndex][Common.VbecsTables.CannedComment.CannedCommentGuid];
				//
				this.SetDirtyFlag(sender, e);
			}
		}

		/// <summary>
		/// Details text box text changed event handler.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void txtDetails_TextChanged(object sender, System.EventArgs e)
		{
			this.CheckValid();
			//
			if (txtDetails.Text.Trim().Length > 0)
			{
				this.SetDirtyFlag(sender, e);
			}
		}

		private void cmbABO_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.CheckValid();
			//
			if (cmbABO.SelectedIndex > -1)
			{
				this.SetDirtyFlag(sender, e);
			}
		}

		private void cmbRh_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.CheckValid();
			//
			if (cmbRh.SelectedIndex > -1)
			{
				this.SetDirtyFlag(sender, e);
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmJustifyAboRHChange_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			
			textToSpeak = string.Concat(textToSpeak, "\n", this.patientDisplayPanel1.GetErrorMessagesFor508());
			// 
			if (this.pnlSelectPatient.Visible)
			{
				textToSpeak = this.patientSelectTool1.GetErrorMessagesFor508();
			}
			if (!this.btnOK.EnabledButton && this.pnlSelectPatient.Visible)
			{
				textToSpeak = this.patientSelectTool1.GetErrorMessagesFor508();
				textToSpeak = string.Concat(textToSpeak, "\n", this.btnOK.GetToolTip());
			}
			else if (!this.btnSave.EnabledButton && this.pnlJustifyABORh.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, "\n", this.btnSave.GetToolTip());
			}
			if(this.patientDisplayPanel1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientDisplayPanel1.GetErrorMessagesFor508());
			}
			if(this.patientSelectTool1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak,this.patientSelectTool1.GetErrorMessagesFor508());
			}
			//
			this.SpeakMessage( textToSpeak );
		}	

		#endregion

		#region Methods

		/// <summary>
		/// Load comment combo box with canned comments from Justify ABO/Rh Change context.
		/// </summary>
		private void LoadCannedComments()
		{
			_dtComments = BOL.CannedComment.GetCannedComments(Common.LogonUser.LogonUserDivisionCode, "AB");

			this.cmbComment.Items.Clear();
			foreach(DataRow dr in _dtComments.Rows)
			{
				this.cmbComment.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString());
			}
		}

		/// <summary>
		/// Initialize user control properties.
		/// </summary>
		private void SetComponentProperties()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC100JustifyPatientABORh;
			//
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC100.FrmJustifyAboRHChange());
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);
			//
			this.btnSave.EnabledButton = false;
			this.btnSave.Text = "&OK";
			//
			this.SetThisToolTip(btnCancel,Common.StrRes.Tooltips.Common.Cancel());
			this.SetThisToolTip(btnCancelChange,Common.StrRes.Tooltips.Common.Cancel());
			//
			this.LoadABOComboBox();
			this.LoadRhComboBox();
		}

		/// <summary>
		/// Load ABO combo box with valid blood types.
		/// </summary>
		private void LoadABOComboBox()
		{
			this.cmbABO.Items.Clear();
			//
			this._abo = new ArrayList(5);
			this._abo.Add("A");
			this._abo.Add("B");
			this._abo.Add("AB");
			this._abo.Add("O");
			this._abo.Add("I");
			//
			foreach(string abo in this._abo)
			{
				if (abo=="I")
				{
					cmbABO.Items.Add("Inconclusive");
				}
				else
				{
					cmbABO.Items.Add(abo);
				}
			}
		}

		/// <summary>
		/// Load Rh combo box with valid Rh factor codes.
		/// </summary>
		private void LoadRhComboBox()
		{
			this.cmbRh.Items.Clear();
			//
			this._rh = new ArrayList(3);
			this._rh.Add("P");
			this._rh.Add("N");
			this._rh.Add("I");
			//
			cmbRh.Items.Add("Pos");
			cmbRh.Items.Add("Neg");
			cmbRh.Items.Add("Inconclusive");
		}

		/// <summary>
		/// Loads historical ABO/Rh and current specimen ABO/Rh for the selected patient.
		/// Also defaults justified ABO and Rh selections.
		/// </summary>
		private void LoadPatient()
		{
			BOL.SpecimenTest aboCurrent = (BOL.SpecimenTest)_patientABORhHistory[0];
			BOL.SpecimenTest rhCurrent = (BOL.SpecimenTest)_patientABORhHistory[1];
			//
			txtCurrentABO.Text = aboCurrent.TestResult.TestResultText;
			txtCurrentABOComment.Text = aboCurrent.TestComments;
			txtCurrentDate.Text = Common.VBECSDateTime.FormatDateTimeString(aboCurrent.TestDate);
			BOL.Division currentDivision = new BOL.Division(aboCurrent.DivisionCode);
			txtCurrentDivision.Text = currentDivision.DivisionName;
			txtCurrentRh.Text = rhCurrent.TestResult.TestResultText;
			txtCurrentRhComment.Text = rhCurrent.TestComments;
			//
			if (this._patientABORhHistory.Count == 2)
			{
				this.txtHistoricalTested.Text = "";
				this.txtHistoricalDivision.Text = "";
				this.txtHistoricalABO.Text = _patient.ConversionAboRH.Abo.ToString();
				this.txtHistoricalABOComment.Text = "Converted from VistA";
				this.txtHistoricalRh.Text = _patient.ConversionAboRH.RHFactorText;
				this.txtHistoricalRhComment.Text = "Converted from VistA";
			}
			else
			{
				BOL.SpecimenTest aboHistorical = (BOL.SpecimenTest)_patientABORhHistory[2];
				BOL.SpecimenTest rhHistorical = (BOL.SpecimenTest)_patientABORhHistory[3];
				//
				this.txtHistoricalTested.Text = Common.VBECSDateTime.FormatDateTimeString(aboHistorical.TestDate);
				BOL.Division historicalDivision = new BOL.Division(aboHistorical.DivisionCode);
				this.txtHistoricalDivision.Text = historicalDivision.DivisionName;
				this.txtHistoricalABO.Text = aboHistorical.TestResult.TestResultText;
				this.txtHistoricalABOComment.Text = aboHistorical.TestComments;
				this.txtHistoricalRh.Text = rhHistorical.TestResult.TestResultText;
				this.txtHistoricalRhComment.Text = rhHistorical.TestComments;
			}
			//
			cmbABO.SelectedItem = txtCurrentABO.Text.Trim();
			cmbRh.SelectedItem = txtCurrentRh.Text.Trim();
		}

		/// <summary>
		/// Checks whether to enable the save button, based on ABO/Rh and comments entered.
		/// </summary>
		private void CheckValid()
		{
			string tooltip = "";
			if ((this.cmbABO.SelectedIndex<0)||(this.cmbRh.SelectedIndex<0))
			{
				tooltip+=Common.StrRes.Tooltips.UC100.JustifiedABORh().ResString+"\n";
			}
			if (this.cmbComment.SelectedIndex<0)
			{
				tooltip += Common.StrRes.Tooltips.Common.EnterAComment().ResString+"\n";
			}
			else if (_detailsRequired && (this.txtDetails.Text.Trim().Length==0))
			{
				tooltip += Common.StrRes.Tooltips.Common.CommentRequiredWithOther().ResString+"\n";
			}
			btnSave.EnabledButton = (tooltip.Length==0);
			//
			if (!btnSave.EnabledButton)
			{
				this.btnSave.SetToolTip(tooltip);
			}
			else
			{
				this.btnSave.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
			}
		}

		/// <summary>
		/// Checks whether a free text comment is required, based on the canned comment selected.
		/// </summary>
		private void CheckIfDetailsRequired()
		{
			//Details required if Comment = Other
			if (this.cmbComment.Text.Trim().ToUpper() == "OTHER")
			{
				this.lblDetails.Text = "Details*";
				this._detailsRequired = true;
			}
			else
			{
				this.lblDetails.Text = "Details";
				this._detailsRequired = false;
			}
		}

		#endregion
	}
}

